document.addEventListener("DOMContentLoaded", function () {
  // Load header
  fetch("header.html")
    .then((response) => {
      if (!response.ok)
        throw new Error(`HTTP error! Status: ${response.status}`);
      return response.text();
    })
    .then((data) => {
      document.getElementById("header").outerHTML = data; // replaces <header id="header">
    })
    .catch((err) => console.error("Header load error:", err));

  // Load footer
  fetch("footer.html")
    .then((response) => {
      if (!response.ok)
        throw new Error(`HTTP error! Status: ${response.status}`);
      return response.text();
    })
    .then((data) => {
      document.getElementById("footer").outerHTML = data; // replaces <footer id="footer">
    })
    .catch((err) => console.error("Footer load error:", err));
});
